#!/bin/bash
#SBATCH --nodes=1
#SBATCH --gres=gpu:1
#SBATCH --ntasks-per-node=1
#SBATCH --partition=gpu
#SBATCH --cpus-per-task=9
#SBATCH --job-name=IN1k-LP
#SBATCH --time=96:00:00
#SBATCH --mem=120G
#SBATCH --constraint=v100|rtx6k|rtx8k|p40|v100s
#SBATCH --exclude=gnodee8,gnodec1

#mocov2/in1k
EXP_STR="mocov2/user-bal-zoom0.1-BS512-LR0.06-EP200-temp-0.2"
EXPERIMENT_PATH="/scratch/shared/beegfs/yuki/adiwol/experiments/yuki/${EXP_STR}/LP"
MODEL_STR=${EXPERIMENT_PATH}/checkpoint.pth.tar

mkdir -p $EXPERIMENT_PATH
echo "will use" ${MODEL_STR}

CUDA_VISIBLE_DEVICES=0 /scratch/shared/beegfs/yuki/envs/py37/bin/python3 main_lincls.py \
            -a resnet50 \
            --dataset 'objnet' \
            --workers 12 \
            --batch-size 64 \
            --resume ${MODEL_STR} \
            --dump_path ${EXPERIMENT_PATH} \
            --evaluate \
            " " 2>&1 | tee -a ${EXPERIMENT_PATH}/objnet-log.txt